//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
//  
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Text;
using System.Text.RegularExpressions;
using System.Net;
using System.Net.Sockets;
using System.Threading;
using System.Diagnostics;

namespace Messenger
{
	/// <summary>
	/// Podsumowanie dla ChatForm.
	/// </summary>
	public class ChatForm : System.Windows.Forms.Form
	{
		public Hangup HangupCallback;
		private string client;
		private string user;
		private string nickname;
		private Socket socket;
		private MessengerForm parent;
		private Thread thread;
		private System.Windows.Forms.RichTextBox conversation;
		private System.Windows.Forms.StatusBar statusBar;
		/// <summary>
		/// Wymagana zmienna.
		/// </summary>
		private System.ComponentModel.Container components = null;

		private void ChatSocketMain()
		{
			string strData;
			byte[] buff;
			while (socket != null && socket.Connected)
			{
				if (socket.Available > 0)
				{
					try
					{
						buff = new byte[socket.Available];
						socket.Receive(buff, socket.Available, SocketFlags.None);
						strData = UTF8Encoding.UTF8.GetString(buff);
						ProcessSBData(socket, strData);
					}
					catch (SocketException sec)
					{
						Debug.WriteLine(sec.Message + sec.StackTrace);
					}
					catch (ThreadAbortException)
					{
					}
					catch (Exception ec)
					{
						Debug.WriteLine(ec.Message + ec.StackTrace);
					}
				}			
			}
			if(socket.Connected == false)
			{
				Debug.WriteLine(user + " disconnected");
			}
		}

		private void ProcessSBData(Socket s, string strData)
		{
			//   Wysanie byskawicznej wiadomoci
			//
			//   Po nawizaniu sesji midzy klientami poprzez Switchboard Server
			//   wysyanie wiadomoci do uczestnikw sesji odbywa si
			//   w nastpujcy sposb:
			//
			//        C: MSG TrID [U | N | A] Dugo\r\nWiadomo
			//        S: NAK TrID
			//        S: ACK TrID
			//
			//   U, N i A to trzy tryby potwierdzania odbioru wiadomoci:
			//   Unacknowledged (bez potwierdzania), Negative-Acknowledgement-Only 
			//   (tylko bdy) oraz Acknowledgement (potwierdzanie).
			//   W zalenoci od wartoci tego parametru Switchboard Serve nie przele nic
			//   lub przele do klienta NAK albo ACK.
			//
			//   W trybie Unacknowledged serwer Switchboard Server nie informuje
			//   nadawcy o sukcesie lub niepowodzeniu w czasie dorczania wiadomoci.
			//
			//   W trybie Negative-Acknowledgement-Only serwer Switchboard Server
			//   odpowiada klientowi tylko jeli wiadomo nie zostaa dorczona
			//   do adresata.
			//
			//   Tryb Acknowledgement nie zosta jeszcze zaimplementowany.
			//
			//   Dugo to rozmiar parametru Wiadomo, podczas gdy Wiadomo to
			//   przesyana wiadomo.

			Debug.WriteLine("Odebrano SB (" + user + ") Dane: \n" + strData);
			if (strData.IndexOf("ANS") != -1)
			{		
			}
			if (strData.IndexOf("MSG") != -1)
			{		
				Regex tuserregex = new Regex(@"(?<MSG>MSG) (?<user>[^ ]+) (?<alias>[^ ]+) (?<length>[0-9]+)\r\n(?<header>(.+\r\n)+TypingUser: (?<tuser>.+)\r\n\r\n)");
				Match mc = tuserregex.Match(strData);
				if(mc.Success)
				{
					statusBar.Text = "Wpisz uytkownika: " + mc.Groups["tuser"].Value;
				}
				else
				{
					Regex msgregex = new Regex(@"(?<MSG>MSG) (?<user>[^ ]+) (?<alias>[^ ]+) (?<length>[0-9]+)\r\n(?<header>(.+\r\n)+\r\n)");
					mc = msgregex.Match(strData);
					if(mc.Success)
					{
						string msg = strData.Substring(mc.Length);
						msg.TrimEnd();
						conversation.AppendText(msg + "\n");
						statusBar.Text = "";
					}
				}
			}
			if (strData.IndexOf("BYE") != -1)
			{		
				if(HangupCallback != null)
				{
					Regex byeregex = new Regex(@"(?<BYE>BYE) (?<user>.+)");
					Match mc = byeregex.Match(strData);
					if(mc.Success)
					{
						parent.BeginInvoke(HangupCallback,
							new object[] { 	mc.Groups["user"].Value.TrimEnd() } );
					}
				}
			}
		}

		public ChatForm()
		{
			//
			// Wymagane do obsugi Windows Form Designer
			//
			InitializeComponent();
		}

		public string Client
		{
			get
			{
				return client;
			}
			set
			{
				client = value;
			}
		}
		public string User
		{
			get
			{
				return user;
			}
			set
			{
				user = value;
			}
		}
		public string Nickname
		{
			get
			{
				return nickname;
			}
			set
			{
				nickname = value;
			}
		}
		public Socket Connection
		{
			get
			{
				return socket;
			}
			set
			{
				socket = value;
			}
		}
		public MessengerForm Root
		{
			get
			{
				return parent;
			}
			set
			{
				parent = value;
			}
		}
		public void Start()
		{
			thread = new Thread(new ThreadStart(ChatSocketMain));
			thread.Name = "SB " + user;
			thread.Start();
		}

		/// <summary>
		/// Oczyszczenie uywanych zasobw.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}

				if(thread != null && thread.ThreadState != System.Threading.ThreadState.Unstarted)
				{
					thread.Abort();
					thread.Join();
				}

				socket.Close();
				socket = null;
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Metoda wymagana do obsugi Designera - nie naley modyfikowa
		/// zawartoci tej metody przy uyciu edytora kodu.
		/// </summary>
		private void InitializeComponent()
		{
			this.conversation = new System.Windows.Forms.RichTextBox();
			this.statusBar = new System.Windows.Forms.StatusBar();
			this.SuspendLayout();
			// 
			// conversation
			// 
			this.conversation.Location = new System.Drawing.Point(9, 56);
			this.conversation.Name = "conversation";
			this.conversation.ReadOnly = true;
			this.conversation.Size = new System.Drawing.Size(497, 234);
			this.conversation.TabIndex = 1;
			this.conversation.Text = "";
			// 
			// statusBar
			// 
			this.statusBar.Location = new System.Drawing.Point(0, 292);
			this.statusBar.Name = "statusBar";
			this.statusBar.Size = new System.Drawing.Size(523, 25);
			this.statusBar.TabIndex = 2;
			// 
			// ChatForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(6, 15);
			this.ClientSize = new System.Drawing.Size(523, 317);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.statusBar,
																		  this.conversation});
			this.Name = "ChatForm";
			this.Text = "ChatForm";
			this.ResumeLayout(false);

		}
		#endregion

	}
}
